/*
 * Decompiled with CFR 0.152.
 */
package model.components.schedulers;

import model.components.schedulers.Scheduler;
import model.experiment.ExperimentSimplePiston;
import settings.Settings;
import visualization.gui.components.MainStageController;

public class PistonScheduler
extends Scheduler<ExperimentSimplePiston> {
    private final int pistonMode;
    private final double targetVolume;

    public PistonScheduler(String name, int pistonMode, double targetVolume, double startTime, MainStageController overlordIn) {
        this.type = "Piston";
        this.name = name;
        this.pistonMode = pistonMode;
        this.targetVolume = targetVolume;
        this.time = startTime;
        this.overlord = overlordIn;
    }

    public String toString() {
        return "";
    }

    public int getPistonMode() {
        return this.pistonMode;
    }

    public double getTargetVolume() {
        return this.targetVolume;
    }

    @Override
    public void update(double iterationID) {
        double iterationTime = iterationID / (double)Settings.numberOfTimeSteps * Settings.totalTime;
        if (!this.hasFired && iterationTime >= this.time) {
            this.overlord.getExperiment().pistonMode = this.pistonMode;
            this.overlord.getExperiment().targetVolume = this.targetVolume;
            this.hasFired = true;
        }
    }
}

