/*
 * Decompiled with CFR 0.152.
 */
package model.components.basic;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import model.components.basic.WallStaticBottom;
import model.physics.properties.TemperatureObject;
import settings.Settings;
import visualization.gui.UtilsUI;

public class WallStaticBottomHeater
extends WallStaticBottom
implements TemperatureObject {
    public double temperature;
    public static double tempMax = Settings.temperatureMaxColoring;
    public static final int ALIGN_TOP = 0;
    public static final int ALIGN_BOTTOM = 1;
    int alignment;

    public WallStaticBottomHeater(double x1In, double x2In, double yIn, double temperature, int alignment) {
        super(x1In, x2In, yIn);
        this.temperature = temperature;
        this.alignment = alignment;
    }

    @Override
    public void draw(Graphics2D context) {
        context.setColor(new Color(51, 51, 51));
        int thickness = (int)Math.max(2.0, 0.05 * Settings.pixelsInAMeter);
        if (this.alignment == 0) {
            context.fillRoundRect((int)(Math.min(this.pos[0], this.pos[3]) - (double)thickness), (int)this.pos[1], (int)(Math.abs(this.pos[0] - this.pos[3]) + (double)(2 * thickness)), thickness, 10, 10);
        }
        if (Settings.allowHeating) {
            context.setColor(UtilsUI.getTemperatureColor(this.temperature));
            context.fillRoundRect((int)(Math.min(this.pos[0], this.pos[3]) - (double)(thickness / 3)), (int)this.pos[1], (int)(Math.abs(this.pos[0] - this.pos[3]) + (double)(3 * thickness / 3)), thickness / 3, thickness / 6, thickness / 6);
            FontMetrics metrics = context.getFontMetrics(context.getFont());
            context.setColor(Color.ORANGE);
            context.drawString(String.format("Heater Temperature: %d K", (int)this.temperature), (int)(Math.min(this.pos[0], this.pos[3]) + Math.abs(this.pos[0] - this.pos[3]) / 2.0 - (double)(metrics.stringWidth(String.format("Heater Temperature: %d K", (int)this.temperature)) / 2)), (int)(this.pos[1] + (double)(thickness / 3) + (double)metrics.getHeight()));
        } else {
            FontMetrics metrics = context.getFontMetrics(context.getFont());
            context.setColor(Color.ORANGE);
            context.drawString("Heaters disabled", (int)(Math.min(this.pos[0], this.pos[3]) + Math.abs(this.pos[0] - this.pos[3]) / 2.0 - (double)(metrics.stringWidth("Heaters disabled") / 2)), (int)(this.pos[1] + (double)(thickness / 3) + (double)metrics.getHeight()));
        }
    }

    @Override
    public double getT() {
        return this.temperature;
    }

    @Override
    public void setT(double t) {
        this.temperature = t;
    }
}

